#!/bin/python
# Simple two speed fan control by Ian Hill ianwilliamhill.co.uk

import RPi.GPIO as GPIO
import time
import os

# Setup temperature values here
maxTemp = 65 # CPU Temp threshold to raise the fan's speed, value is in degrees C
minTemp = 58 # CPU Temp threshold to lower the fan's speed, value is in degrees C
sleepTime = 60 # Period of sleep between checking temp, value is in seconds (60 = 1 minute)

# Setup GPIO pin numbers here
# Use the Broadcom SOC Pin numbers
led1 = 19 # Green LED, shows script is running
led2 = 16 # Red LED, shows fan is (or should be) at maximum speed
fan = 14 # GPIO pin to fan transistor base

# Main script, do not modify the below...
print "Starting fan control..."
GPIO.setmode(GPIO.BCM)
GPIO.setup(led1,GPIO.OUT)
GPIO.setup(led2,GPIO.OUT)
GPIO.setup(fan,GPIO.OUT)
GPIO.output(led1,GPIO.HIGH)
time.sleep(1)
print "Test high speed for five seconds..."
GPIO.output(led2,GPIO.HIGH)
GPIO.output(fan,GPIO.HIGH)
time.sleep(5)
print "Test complete..."
time.sleep(1)
print "Returning to low speed..."
GPIO.output(led2,GPIO.LOW)
GPIO.output(fan,GPIO.LOW)

def getCPUtemperature():
   res = os.popen('vcgencmd measure_temp').readline()
   return(res.replace("temp=","").replace("'C\n","").replace(" ",""))

temp=int(float(getCPUtemperature()))
print "CPU Temperature is",temp,"C"
time.sleep(1)
print "Starting main thread..."

try:
   while True:
      temp1=int(float(getCPUtemperature()))
      if temp > maxTemp:
         GPIO.output(fan,GPIO.HIGH)
         GPIO.output(led2,GPIO.HIGH)
      elif temp < minTemp:
         GPIO.output(fan,GPIO.LOW)
         GPIO.output(led2,GPIO.LOW)   
      time.sleep(sleepTime)
except KeyboardInterrupt:
   print "\n","CTRL+C Called. Exiting..."

except:
   print "Some other error occurred..."

finally:
   GPIO.cleanup()
